#if NUNIT
#region Directives
//-----------------------***
using System;
using System.Collections;
using System.Data;
using System.Text;
using NUnit.Framework;
using gov.va.med.vbecs.UnitTests;

using TABLES = gov.va.med.vbecs.Common.VbecsTables;
using SPROCS = gov.va.med.vbecs.Common.VbecsStoredProcs;
using ARTIFICIAL = gov.va.med.vbecs.Common.DatabaseConstants.ArtificialColumnNames;


using BOL = gov.va.med.vbecs.BOL;
using COMMON = gov.va.med.vbecs.Common;
using DAL = gov.va.med.vbecs.DAL;
using VAL = gov.va.med.vbecs.VAL;
using gov.va.med.vbecs.VAL.UnitTests;
//-----------------------***
#endregion
namespace gov.va.med.vbecs.BOL.UnitTests
{

	
	

	[TestFixture]
	public class BOL_FacilityDefinition : BaseTest 
	{
		private FacilityDefinition GetTestFacilityDefition()
		{
			IEnumerator _en = FacilityDefinition.GetAllSortedByName().GetEnumerator();
			_en.MoveNext();

			return (FacilityDefinition)_en.Current;
		}

		[Test]
		public void FacilityGuid_Pass()
		{
			Assert.IsTrue( GetTestFacilityDefition().FacilityGuid != Guid.Empty );
		}

		[Test]
		[Ignore(StandardIgnoreReasons.ReadOnlyProperty)]
		public void FacilityGuid_Fail() {}

		[Test]
		public void FacilityName_Pass()
		{
			Assert.IsNotNull( GetTestFacilityDefition().FacilityName );
		}

		[Test]
		[Ignore(StandardIgnoreReasons.ReadOnlyProperty)]
		public void FacilityName_Fail(){}

		[Test]
		public void CombinedName_Pass()
		{
			Assert.IsNotNull( GetTestFacilityDefition().CombinedName );
		}

		[Test]
		[Ignore(StandardIgnoreReasons.ReadOnlyProperty)]
		public void CombinedName_Fail(){}

		[Test]
		public void FdaRegistrationNumber_Pass()
		{
			Assert.IsNotNull( GetTestFacilityDefition().FdaRegistrationNumber );
		}

		[Test]
		[Ignore(StandardIgnoreReasons.ReadOnlyProperty)]
		public void FdaRegistrationNumber_Fail() {}

		[Test]
		public void GetAllSortedByName_Pass()
		{
			Assert.IsNotNull( FacilityDefinition.GetAllSortedByName() );
		}

		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void GetAllSortedByName_Fail() {}

		[Test]
		public void GetByGuid_Pass()
		{
			FacilityDefinition tmpFD = FacilityDefinition.GetByGuid(GetTestFacilityDefition().FacilityGuid);

			Assert.AreEqual( tmpFD.FacilityGuid, GetTestFacilityDefition().FacilityGuid );
		}

		[Test]
        [ExpectedException(typeof(Common.DataAccessLayerException))]
		public void GetByGuid_Fail()
		{
			FacilityDefinition tmpFD = FacilityDefinition.GetByGuid(System.Guid.NewGuid());

			Assert.IsNotNull( tmpFD );
		}

		[Test]
		public void GetObjectID_Pass()
		{
			Assert.IsNotNull( GetTestFacilityDefition().GetObjectID() );
		}

		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void GetObjectID_Fail() {}
	}
}

#endif
